import React, { Component } from 'react';
import { ScrollView, StyleSheet, View, Text } from 'react-native';
import Counter from './Counter';
import PeopleList from './PeopleList';
import Form from './Form';

const data = [
  { name: 'Charlie', job: 'Janitor' },
  { name: 'Mac', job: 'Bouncer' },
  { name: 'Dee', job: 'Aspring actress' },
  { name: 'Dennis', job: 'Bartender' },
  { name: 'DennisA', job: 'BartenderA' },
  { name: 'DennisB', job: 'BartenderB' },
  { name: 'DennisC', job: 'BartenderC' },
];

class App extends Component {
  constructor(props) {
    super(props);
    this.state = {
      title: "DSSMV: React - native example",
      people: data,
    };
  }
  deletePerson = name => {
    const { people } = this.state;
    let newList = [...people];
    newList = newList.filter(item => item.name.trim() !== name.trim());
    this.setState({ people: newList, });
  };
  addPerson = person => {
    const { people } = this.state;
    let newList = [...people, person];
    this.setState({ people: newList });
  };
  render() {
    const { title, people } = this.state;
    return (
      <ScrollView>
        <Text>{title}</Text>
        <Counter />
        <Form addItem={this.addPerson} />
        <PeopleList listOfItems={people} deleteItem={this.deletePerson} />
      </ScrollView>
    );
  }
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    marginTop: 0,
  },
  item: {
    backgroundColor: '#f9c2ff',
    padding: 20,
    marginVertical: 8,
    marginHorizontal: 16,
  },
  title: {
    fontSize: 32,
  },
});

export default App;
